package gov.va.med.mhv.sm.admin.repository;

import java.util.Collection;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import gov.va.med.mhv.sm.admin.model.Message;

@Repository
public interface MessageRepository extends JpaRepository<Message, Long>{
	
	/**
	 * findMessageById
	 * @param id
	 * @return Message
	 */
	@Query("select m from Message m where m.id = :id")
	Message findMessageById(@Param("id") Long id);
	
	@Query("select m from Message m where threadId =:threadId")
	Collection<Message> getMessagesByThread(@Param("threadId") Long threadId);
	
}